<?php

/*

* Plugin Name:	Renommer les projets de Divi
* Plugin URI:		https://www.divi-community.fr/tutoriels-divi/comment-renommer-les-projets-divi
* Description:	Renommez le custom post type "projets" sans avoir de thème enfant. ℹ <a href="https://www.divi-community.fr/tutoriels-divi/comment-renommer-les-projets-divi" target="_blank">Voir comment faire</a>.
* Version:			1
* Author:       Pierre Bichet pour Divi Community 🚀
* Author URI:		https://www.divi-community.fr

*/

function DC_renommer_projets_divi() {

/* Renommer le custom post type */
    register_post_type( 'project',
        array(
            'labels' => array(
              'name' => __( 'Véhicules', 'divi' ),
              'singular_name' => __( 'Véhicule', 'divi' ),

        ),
        'has_archive' => true,
        'hierarchical' => true,
        'public' => true,
        'rewrite' => array( 'slug' => 'vehicules', 'with_front' => false ),
        'supports' => array(),
        'menu_icon' => 'dashicons-marker',
    ));

/* Renommer la catégorie */
    register_taxonomy( 'project_category', array( 'project' ),
      array(
        'labels' => array(
          'name' => _x( 'Catégories de véhicules', 'Catégories de véhicules', 'Divi' ),
      ),
        'hierarchical' => true,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
    ) );

/* Renommer les étiquettes */
    register_taxonomy( 'project_tag', array( 'project' ),
      array(
        'labels' => array(
          'name' => _x( 'Étiquettes des véhicules', 'Étiquettes des véhicules', 'Divi' ),
      ),
        'hierarchical' => true,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
    ) );

}
add_action( 'init', 'DC_renommer_projets_divi' );
